/*
Copyright 2008-2009 Elöd Egyed-Zsigmond, Cyril Laitang
Copyright 2009-2011 Samuel Gesche

This file is part of IPRI News Analyzer.

IPRI News Analyzer is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

IPRI News Analyzer is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with IPRI News Analyzer.  If not, see <http://www.gnu.org/licenses/>.
*/

package proc.cluster;

import data.structures.corpus.ClusteringCorpusGraph;

public class Experiences {
    private final static Experience XP1 = new Experience();
    private final static Experience XP2 = new Experience();
    private final static Experience XP3 = new Experience();
    private final static Experience[] liste = new Experience[]{
        XP1, XP2, XP3};

    static{
        //Initialisation des expériences
        XP1.setTitre("Expérience I - Clustering basique");
        XP1.setDesc("<html>Enrichissement de base. <br> " +
                "Poids : chaque lemme a un poids de 1 quel que soit le " +
                "nombre de fois où il apparaît ; <br>les noms communs " +
                "et propres ont un poids de 1, les autres catégories ont un poids nul.");
        XP1.setEnrichArticleBase(true);
        XP1.setEnrichArticleGen(false);
        XP1.setEnrichArticleCat(false);
        XP1.setEnrichArticleSem(false);
        XP1.annulePoidsCategories();
        XP1.setPoidsCategorie("NOM", 1.0);
        XP1.setPoidsCategorie("NAM", 1.0);
        XP1.setNormalisationTaille(true);
        XP1.setAlgoCalcul(Experience.VECTEUR_PRODUIT_SCALAIRE);
        XP2.setTitre("Expérience I - Clustering basique");
        XP2.setDesc("<html>Enrichissement de base. <br> " +
                "Poids : chaque lemme a un poids de 1 quel que soit le " +
                "nombre de fois où il apparaît ; <br>les noms communs " +
                "et propres ont un poids de 1, les autres catégories ont un poids nul.");
        XP2.setEnrichArticleBase(true);
        XP2.setEnrichArticleGen(false);
        XP2.setEnrichArticleCat(false);
        XP2.setEnrichArticleSem(false);
        XP2.annulePoidsCategories();
        XP2.setPoidsCategorie("NOM", 1.0);
        XP2.setPoidsCategorie("NAM", 1.0);
        XP2.setNormalisationTaille(true);
        XP2.setAlgoCalcul(Experience.VECTEUR_DISTANCE_EUCLIDIENNE);
        XP3.setTitre("Expérience I - Clustering basique");
        XP3.setDesc("<html>Enrichissement de base. <br> " +
                "Poids : chaque lemme a un poids de 1 quel que soit le " +
                "nombre de fois où il apparaît ; <br>les noms communs " +
                "et propres ont un poids de 1, les autres catégories ont un poids nul.");
        XP3.setEnrichArticleBase(true);
        XP3.setEnrichArticleGen(false);
        XP3.setEnrichArticleCat(false);
        XP3.setEnrichArticleSem(false);
        XP3.annulePoidsCategories();
        XP3.setPoidsCategorie("NOM", 1.0);
        XP3.setPoidsCategorie("NAM", 1.0);
        XP3.setNormalisationTaille(true);
        XP3.setAlgoCalcul(Experience.VECTEUR_DISTANCE_DE_MANHATTAN);
    }

    public static Experience[] getExperiences(){
        return liste;
    }

    public static void setCorpus(ClusteringCorpusGraph corpus){
        for(int i=0; i<liste.length; i++){
            liste[i].setCorpus(corpus);
        }
    }

    public static void setBase(data.base.Database base){
        for(int i=0; i<liste.length; i++){
            liste[i].setBase(base);
        }
    }
}
